#
# Mark J Cox, mark@awe.com for www.sonik.co.uk, February 2011
#
#   Copyright 2011 Mark J Cox
#
#    Licensed under the Apache License, Version 2.0 (the "License");
#    you may not use this file except in compliance with the License.
#    You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.
#
#
# turn your video into a directory of images one per frame:
#    mplayer 100_0030.MOV -vo jpeg:outdir=100_0030
#

use GD;
my @S;

$l = 0;
while(<>) {
    chop;
    foreach my $s (@s = split(/\s+/)) {
        ($x,$y) = split('=',$s,2);
        $S[$l]{$x}=$y;
    }
    if ($S[$l]{movie}) {
        $l++;
    }
}
$draw_debug_boxes = $S[0]{debugboxes} || 0;
die "missing script" if ($l==0); 

use threads;
my $cores=2; # Use 8 for Marks machine

$|=1;
GD::Image->trueColor(1);

system("rm /dev/shm/out/*jpg");
system("mkdir  /dev/shm/out");
for ($dst_frame = 1; $dst_frame < $S[0]{maxframes}; $dst_frame++) {
    print "\rframe ".sprintf("%08d",$dst_frame)."";
#    process_frame($dst_frame);
    my @T;
    for ($t=0;$t<$cores;$t++) {
        if ($dst_frame+$t < $S[0]{maxframes}) {
            $T[$t] = threads->new(\&process_frame,$dst_frame+$t);
        }
    }
    $T[0]->join;
    $dst_frame+=$cores-1;
}
print "\rwrote $dst_frame frames\n";
$filename = $S[0]{output} || "output.avi";
system("mencoder mf:///dev/shm/out/*.jpg -mf fps=30:type=jpg -ovc lavc -lavcopts vcodec=mpeg4:mbd=2:vbitrate=1000:vbitrate=4000:trell -oac copy -o $filename");
exit;

sub process_frame {
    my ($dst_frame) = @_;
    my $dst_img = new GD::Image(1280,720) || die;
    if ($draw_debug_boxes) {$border = $dst_img->colorAllocate(255,0,0)};

    for ($s=0;$S[$s]{movie};$s++) {
        $S[$s]{frame}=1 if ($S[$s]{frame}<1);

        $frame = $S[$s]{frame} + ($dst_frame-1)*$S[$s]{frameinc};
        $x = $S[$s]{x} + ($dst_frame-1)*$S[$s]{xinc};
        $y = $S[$s]{y} + ($dst_frame-1)*$S[$s]{yinc};

        my %im;
        if (!$im{$S[$s]{movie}.$frame}) {
            $im{$S[$s]{movie}.$frame} = newFromJpeg GD::Image($S[$s]{movie}."/".sprintf("%08d",$frame).".jpg");
        }
        $dst_img->copy($im{$S[$s]{movie}.$frame},$x,$y,$x+$S[$s]{xoff},$y+$S[$s]{yoff},$S[$s]{w},$S[$s]{h});
        if ($draw_debug_boxes) {
            $dst_img->line($x,$y,$x+$S[$s]{w},$y,$border);
            $dst_img->line($x,$y,$x,$y+$S[$s]{h},$border);
            $dst_img->line($x+$S[$s]{w},$y,$x+$S[$s]{w},$y+$S[$s]{h},$border);
            $dst_img->line($x,$y+$S[$s]{h},$x+$S[$s]{w},$y+$S[$s]{h},$border);
            $dst_img->string(gdSmallFont,$x+2,$y+2,$S[$s]{movie}.":".$frame,$border);
        }
    }
    open(OUT,">/dev/shm/out/".sprintf("%08d",$dst_frame).".jpg");
    binmode OUT;
    print OUT $dst_img->jpeg(100);
    close OUT;
}
