// mark1Dlg.cpp : implementation file
//

#include "stdafx.h"
#include "mark1.h"
#include "mark1Dlg.h"

extern "C"
{
#include "opie/opie_cfg.h"
#include "opie/opie.h"
}

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMark1Dlg dialog

CMark1Dlg::CMark1Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMark1Dlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMark1Dlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDI_ICON1);
}

void CMark1Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMark1Dlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMark1Dlg, CDialog)
	//{{AFX_MSG_MAP(CMark1Dlg)
	ON_BN_CLICKED(IDC_COMPUTE, OnCompute)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMark1Dlg message handlers

BOOL CMark1Dlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	CenterWindow(GetDesktopWindow());	// center to the hpc screen

	/* grab stuff from the registry when we start, because it's likely
	 * that the user will want the same seed and count
	 */

	CWinApp *pApp = AfxGetApp();
	CString defSeed, defCount, defAlgo;
	defSeed = pApp->GetProfileString(_T("skey"),_T("seed"));
	defCount = pApp->GetProfileString(_T("skey"),_T("count"));
	defAlgo = pApp->GetProfileString(_T("skey"),_T("algo"));
	if (!defAlgo || defAlgo == "") {
		defAlgo = "otp-md5";
	}
	SetDlgItemText(IDC_SEED,defSeed);
	SetDlgItemText(IDC_COUNT,defCount);
	SetDlgItemText(IDC_PASS,_T(""));
	SetDlgItemText(IDC_ALGO,defAlgo);
	
	return TRUE;  
}


void CMark1Dlg::OnCompute() 
{
	TCHAR szalgo[10],szCount[10],szPass[200],szSeed[20];
	GetDlgItemText(IDC_ALGO, szalgo, 9);
	GetDlgItemText(IDC_COUNT, szCount, 9);
	GetDlgItemText(IDC_PASS, szPass, 199);
	SetDlgItemText(IDC_PASS,_T(""));
	GetDlgItemText(IDC_SEED, szSeed, 19);


	/* save em for next time - we could decrement the count, but
	 * no point second guessing */

	CWinApp* pApp = AfxGetApp();
	pApp->WriteProfileString(_T("skey"),_T("seed"),szSeed);
	pApp->WriteProfileString(_T("skey"),_T("count"),szCount);
	pApp->WriteProfileString(_T("skey"),_T("algo"),szalgo);
	
	CString szQuery = CString(szalgo) + _T(" ") + CString(szCount) + 
		_T(" ") + CString(szSeed);

	char query[80];
	wcstombs(query,szQuery,79);
	char pass[200];
    wcstombs(pass,szPass,199);
	char buffer[300];
	int i = opiegenerator(query,pass,buffer);
	CString response;

	if (i!=0) {
		response.Format(_T("Error: %d"), i);			
	} else {
		response=CString(buffer);
	}
    SetDlgItemText(IDC_RESPONSE,response);
}
